﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;

namespace VIRP_WEB.Controls.Custom.BPR
{
    public partial class controls_UserControlRadioButton : System.Web.UI.UserControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        public string RadioButtonGroup
        {
            set
            {
                RadioButtonControl.GroupName = Helpers.AntiXssEval(value);
            }
        }

        public string RadioButtonValue
        {
            set
            {
                RadioButtonControl.Text = Helpers.AntiXssEval(value);
            }
        }

        public string HelpText
        {
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    LabelHelp.Visible = true;
                    LabelHelp.Text = Helpers.AntiXssEval(value);
                }
                else
                {
                    LabelHelp.Visible = false;
                }
            }
        }

        public bool RadioButtonEditable
        {
            set
            {
                if (value)
                {
                    TextBoxControl.Visible = true;
                }
                else
                {
                    TextBoxControl.Visible = false;
                    LabelforTextBoxControl.Visible = false;
                }
            }
        }
    }
}